<?php

namespace App\Models\UserDetails;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('full_name', 'email', 'user_type_id', 'gender', 'phone_number', 'profile_image', 'identity_image', 'office_manager_membership_number', 'role', 'status');

    public function userType()
    {
        return $this->hasMany('User', 'user_id');
    }

}